/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.network;

import com.flemmli97.improvedmobs.capability.PlayerDifficultyData;
import com.flemmli97.improvedmobs.capability.TileCapProvider;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.difficulty.DifficultyData;
import com.flemmli97.improvedmobs.network.PacketDifficulty;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLConnectionData;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    private static final ResourceLocation channelID = new ResourceLocation("improvedmobs", "packets");
    private static final SimpleChannel dispatcher = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelID).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "v1.0").simpleChannel();

    public static void register() {
        int id = 0;
        dispatcher.registerMessage(id++, PacketDifficulty.class, PacketDifficulty::write, PacketDifficulty::read, PacketDifficulty::handle);
    }

    public static <T> void sendDifficultyToClient(DifficultyData data, ServerPlayerEntity player) {
        if (PacketHandler.hasChannel(player)) {
            dispatcher.sendTo((Object)new PacketDifficulty(Config.CommonConfig.difficultyType == Config.DifficultyType.GLOBAL ? data.getDifficulty() : TileCapProvider.getPlayerDifficultyData(player).map(PlayerDifficultyData::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static <T> void sendDifficultyToAll(DifficultyData data, MinecraftServer server) {
        if (Config.CommonConfig.difficultyType == Config.DifficultyType.GLOBAL) {
            IPacket pkt = dispatcher.toVanillaPacket((Object)new PacketDifficulty(data.getDifficulty()), NetworkDirection.PLAY_TO_CLIENT);
            server.func_184103_al().func_181057_v().forEach(player -> {
                if (PacketHandler.hasChannel(player)) {
                    player.field_71135_a.func_147359_a(pkt);
                }
            });
        } else {
            server.func_184103_al().func_181057_v().forEach(player -> {
                if (PacketHandler.hasChannel(player)) {
                    player.field_71135_a.func_147359_a(dispatcher.toVanillaPacket((Object)new PacketDifficulty(TileCapProvider.getPlayerDifficultyData(player).map(PlayerDifficultyData::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue()), NetworkDirection.PLAY_TO_CLIENT));
                }
            });
        }
    }

    private static boolean hasChannel(ServerPlayerEntity player) {
        FMLConnectionData data = NetworkHooks.getConnectionData((NetworkManager)player.field_71135_a.func_147298_b());
        return data != null && data.getChannels().containsKey((Object)channelID);
    }
}

